/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.config.ConfigurableField;
import jace.core.Computer;
import jace.core.Debugger;
import jace.core.Device;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CPU
extends Device {
    private Debugger debugger = null;
    @ConfigurableField(name="Enable trace to STDOUT", shortName="trace")
    public boolean trace = false;
    @ConfigurableField(name="Trace length", shortName="traceSize", description="Number of most recent trace lines to keep for debugging errors.  Zero == disabled")
    public int traceLength = 0;
    private ArrayList<String> traceLog = new ArrayList();
    public int programCounter = 0;

    @Override
    public String getShortName() {
        return "cpu";
    }

    public boolean isTraceEnabled() {
        return this.trace;
    }

    public void setTraceEnabled(boolean t) {
        this.trace = t;
    }

    public boolean isLogEnabled() {
        return this.traceLength > 0;
    }

    public void log(String line) {
        if (!this.isLogEnabled()) {
            return;
        }
        while (this.traceLog.size() >= this.traceLength) {
            this.traceLog.remove(0);
        }
        this.traceLog.add(line);
    }

    public void dumpTrace() {
        Computer.pause();
        ArrayList newLog = new ArrayList();
        ArrayList<String> log = this.traceLog;
        this.traceLog = newLog;
        Computer.resume();
        System.out.println("Most recent " + this.traceLength + " instructions:");
        for (String s : log) {
            System.out.println(s);
        }
        this.traceLog.clear();
    }

    public void setDebug(Debugger d) {
        this.debugger = d;
        this.suspend();
    }

    public void clearDebug() {
        this.debugger = null;
        this.resume();
    }

    public int getProgramCounter() {
        return this.programCounter;
    }

    public void setProgramCounter(int programCounter) {
        this.programCounter = 0xFFFF & programCounter;
    }

    public void incrementProgramCounter(int amount) {
        this.programCounter += amount;
        this.programCounter = 0xFFFF & this.programCounter;
    }

    @Override
    public void tick() {
        if (this.debugger != null) {
            if (!this.debugger.isActive() && this.debugger.hasBreakpoints()) {
                for (int i : this.debugger.getBreakpoints()) {
                    if (i != this.getProgramCounter()) continue;
                    this.debugger.setActive(true);
                }
            }
            if (this.debugger.isActive()) {
                this.debugger.updateStatus();
                if (!this.debugger.takeStep()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(CPU.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return;
                }
            }
        }
        this.executeOpcode();
    }

    protected abstract void executeOpcode();

    public abstract void reset();

    public abstract void generateInterrupt();

    public abstract void pushPC();

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }
}

